/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;

class InputMethodSupport {
    InputMethodSupport() {
    }

    public static ObservableList<InputMethodTextRun> inputMethodEventComposed(String string, int n) {
        ArrayList<InputMethodTextRun> arrayList = new ArrayList<InputMethodTextRun>();
        if (n < string.length()) {
            arrayList.add(new InputMethodTextRun(string.substring(n), InputMethodHighlight.UNSELECTED_RAW));
        }
        return new ObservableListWrapper<InputMethodTextRun>(arrayList);
    }

    public static String getTextForEvent(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (inputMethodEvent.getText() != null) {
            char c = attributedCharacterIterator.first();
            StringBuilder stringBuilder = new StringBuilder();
            while (c != '\uffff') {
                stringBuilder.append(c);
                c = attributedCharacterIterator.next();
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static class InputMethodRequestsAdapter
    implements java.awt.im.InputMethodRequests {
        private final InputMethodRequests fxRequests;

        public InputMethodRequestsAdapter(InputMethodRequests inputMethodRequests) {
            this.fxRequests = inputMethodRequests;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            AtomicReference<Point2D> atomicReference = new AtomicReference<Point2D>(new Point2D(0.0, 0.0));
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> atomicReference.set(this.fxRequests.getTextLocation(textHitInfo.getInsertionIndex())));
            }
            return new Rectangle((int)atomicReference.get().getX(), (int)atomicReference.get().getY(), 0, 0);
        }

        @Override
        public TextHitInfo getLocationOffset(int n, int n2) {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> atomicInteger.set(this.fxRequests.getLocationOffset(n, n2)));
            }
            return TextHitInfo.afterOffset(atomicInteger.get());
        }

        @Override
        public int getInsertPositionOffset() {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> atomicInteger.set(((ExtendedInputMethodRequests)this.fxRequests).getInsertPositionOffset()));
            }
            return atomicInteger.get();
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> atomicReference.set(((ExtendedInputMethodRequests)this.fxRequests).getCommittedText(n, n2)));
            }
            if ((string = (String)atomicReference.get()) == null) {
                string = "";
            }
            return new AttributedString(string).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> atomicInteger.set(((ExtendedInputMethodRequests)this.fxRequests).getCommittedTextLength()));
            }
            return atomicInteger.get();
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> atomicReference.set(this.fxRequests.getSelectedText()));
            }
            if ((string = (String)atomicReference.get()) == null) {
                string = "";
            }
            return new AttributedString(string).getIterator();
        }
    }
}

